/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (03/06/08)
 */   
package com.ejie.p06b.pdf.xml;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BResources;


/**
 * Clase que representa el xml para el pdf de Test
 */
public class P06BListadoBusquedaXML{
   
	public static String getXml(ArrayList listTest, HttpServletRequest request)
	throws Exception {
		P06BLog.send(2,"P06BListadoBusquedaXML", "getXml(...)");
		
		HashMap datosMap = 
			getDatos(listTest, request);
		ArrayList listRegistros = (ArrayList)datosMap.get("listTest");
		String xml="";
		xml+="<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
		xml+=	"<listado>";
		xml+=		"<fechaObtencion>";
		xml+=			datosMap.get("fechaObtencion");
		xml+=		"</fechaObtencion>";
		xml+=		"<titulo2>";
		xml+=			datosMap.get("titulo2");
		xml+=		"</titulo2>";
		
		for(int i=0;i<listTest.size();i++){
			P06B20T00Datatype registro = 
				(P06B20T00Datatype)listRegistros.get(i);
			xml+=		"<registro>";
			
			//Expediente
			xml+=			"<campoExpediente>";			
			xml+=				(registro.getExpedi()==null)?"":registro.getExpedi();
			xml+=			"</campoExpediente>";
			
			//Nif Cif
			xml+=			"<campoNifCif>";
			xml+=				(registro.getDni()==null)?"":registro.getDni();
			xml+=			"</campoNifCif>";
			
			//Mediador
			xml+=			"<campoMediador>";
			if( (P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA.equals(registro.getClase()))
				|| (P06BConstantes.P06B_AGENTEVINCULADO_FISICA.equals(registro.getClase())) 
				|| (P06BConstantes.P06B_REASEGUROS_FISICA.equals(registro.getClase()))){
				xml += (((registro.getNombre()==null)?"":registro.getNombre()) +" "+ ((registro.getApe1()==null)?"":registro.getApe1()) +" "+ ((registro.getApe2()==null)?"":registro.getApe2()));
			}else{
				xml += ((registro.getRazsoc()==null)?"":registro.getRazsoc());
			}
			xml+=			"</campoMediador>";
			
			//Estado
			xml+=			"<campoEstado>";
			if (P06BConstantes.P06B_CORREDORES_ESTADO_ALTA.equals(registro.getEstado())){
				xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.alta"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_BAJA.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.baja"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_SUSPENSION.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.suspension"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_REVISION.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.revision"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_ALTA.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.pdteAlta"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_PDTE_BAJA.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.pdteBaja"));
		  	}else if (P06BConstantes.P06B_CORREDORES_ESTADO_ALTA_RECHAZADA.equals(registro.getEstado())){
		  		xml += (((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("pantallas.literal.altaRechazada"));
		  	}
			xml+=			"</campoEstado>";
			
			xml+=		"</registro>";
		}
		xml+=	"</listado>";
		
		//En la razon social de algunos mediadores est el smbolo &. Da el error:
		//"The entity name must immediately follow the '&' in the entity reference."
		//Sustituyendo el smbolo & por su codificacin, desaparece el error.
		xml = xml.replaceAll("&","&amp;");
		return xml;
	}
	
	//TODO: Falta de hacer
	//Devolver un hashMap de elementos donde la clave = etiqueta en el xml
	private static HashMap getDatos(ArrayList listTest, HttpServletRequest request)
	throws Exception {
		P06BLog.send(2,"P06BListadoBusquedaXML", "getDatos(...)");
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy"); 
		String fechaObtencion=sdf.format(new java.util.Date());
		
		String campoCodigo = "";
		String campoDescripcion = "";
		String campoValor = "";
		
    	P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS);

    	String sAEPC = (String)request.getSession().getAttribute(P06BConstantes.P06B_AEP_ACCESOEXPPOR);
		String sTitulo2 = "";
		if (sAEPC.equals(P06BConstantes.P06B_AEP_INCORPMODIF)){
			sTitulo2 = res.get("menu.opcion.corredores.incorporaModTramitagune");
		}else if (sAEPC.equals(P06BConstantes.P06B_AEP_REVISIONALTASBAJAS)){
			sTitulo2 = res.get("menu.opcion.corredores.revisarAltasBajasTramitagune");
		}else if (sAEPC.equals(P06BConstantes.P06B_AEP_TRATAMATPETICION)){
			sTitulo2 = "";
		}else if (sAEPC.equals(P06BConstantes.P06B_AEP_BUSQUEDA)){
			sTitulo2 = res.get("menu.opcion.corredores.buscaCorredor");
		}

		
		HashMap datosMap = new HashMap();
		datosMap.put("fechaObtencion",fechaObtencion);
		datosMap.put("listTest",listTest);
		datosMap.put("titulo2",sTitulo2);
		return datosMap;
	}
}